%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Guimera 2007 - Radial flow                                              %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_guimera(r,z,h,lm,lm2,Cw,Cm,Cm2,vT,t,Q,ax)
%--Analytical solution----------------------------------------------------%
AT = (Cw/Cm)*(Q/2/pi/h);  % retarded veloity
R = sqrt(Q*t*Cw/pi/h/Cm); % thermal radius
T = 0.5*erfc((r^2-R^2)/4/sqrt(ax*R^3/3+lm*R^4/4/AT/Cm));  

%--Nomenclature-----------------------------------------------------------%
% r : radial coordinate [m]
% h : aqufer thickness [m]
% uz : thickness of the overlaying layer [m]
% k : bulk thermal conductivity of the aquifer [W/m/K]
% kd : bulk thermal conductivity of the overlaying layer [W/m/K]
% t : simulation time [s]
% vhcw : volumetric heat capacity of the water [J/m^3/K]
% vhcm : volumetric heat capacity of the porous medium (aquifer) [J/m^3/K]
% vhcmd : volumetric heat capacity of the porous medium (confining layers) [J/m^3/K]
% vT : heat transport velocity [m/s]
% ax: longitudinal thermal dispersivity
% Q : injection rate [m^3/s]